#ifndef CE2_TST_DH_KG_H
#define CE2_TST_DH_KG_H

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "CE2_TST_Config.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Wed May 14 16:54:35 2008
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief A brief description of this module
*
*  \version CE2_TST_DH_KG.h#1:incl:1
*  \author Aliaksandr Masiuk
*  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Defines *******************************/

#define TST_MAX_DH_KEY_SIZE 1024
#define TST_NAME_STRING_LEN 150

/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/

typedef struct TST_DH_TestDataStruct
{
	char				TST_Name[TST_NAME_STRING_LEN];
	DxUint32_t			modPsizeBits;
	DxUint32_t			orderQsizeBits;
	DxUint32_t			seedSizeBits;
	DxUint8_t			modP_ptr[TST_MAX_DH_KEY_SIZE];
	DxUint8_t			orderQ_ptr[TST_MAX_DH_KEY_SIZE];
	DxUint8_t			generatorG_ptr[TST_MAX_DH_KEY_SIZE];
	DxUint32_t			generGsizeBytes_ptr;
	DxUint8_t			factorJ_ptr[TST_MAX_DH_KEY_SIZE];
	DxUint32_t			JsizeBytes_ptr;
	DxUint8_t			seedS_ptr[TST_MAX_DH_KEY_SIZE];
	DxInt8_t			generateSeed;
	DxUint32_t			pgenCounter_ptr;
	DxUint8_t			yU[TST_MAX_DH_KEY_SIZE];
	DxUint32_t			yUSizeBytes;
	DxUint8_t			yV[TST_MAX_DH_KEY_SIZE];
	DxUint32_t			yVSizeBytes;
} TST_DH_TestDataStruct;

/************************ Public Variables **********************/

extern TST_DH_TestDataStruct	TST_DH_KG_Acceptance_TestDataStruct[];
extern const int				TST_NumberOf_DH_KG_AcceptanceTests;

/************************ Public Functions **********************/

/*****************************************************************************
* Function Name:                                                           
* 	CE2_ATP_TST_DH_CreateDomainParams_Acceptance
* 
* Inputs:
* 	out - pointer to output log file;
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a Acceptance test for the Diffie-Hellman key agreement 
*  schemes according to ANSI9.42 using full keys test method: P, Q, G, Seed.
*
* Algorithm:		
* 1. Create P, Q, G with using CE2_DH_CreateDomainParams method with test values;
* 2. Validate output data: P, Q, G.
******************************************************************************/
CE2Error_t CE2_ATP_TST_DH_CreateDomainParams_Acceptance(FILE* out);

/*****************************************************************************
* Function Name:                                                           
* 	CE2_ATP_TST_DH_CreateDomainParams_Acceptance
* 
* Inputs:
* 	out - pointer to output log file;
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a test for the Diffie-Hellman key agreement 
*  schemes according to ANSI9.42 using full keys test method: P, Q, G, Seed
*
* Algorithm:		
* 1. Create P, Q, G with using CE2_DH_CreateDomainParams method;
* 2. Validate output data: P, Q, Seed, G with using CE2_DH_CheckDomainParams.
******************************************************************************/
CE2Error_t CE2_ATP_TST_DH_CreateDomainParams(FILE* out);

/*****************************************************************************
* Function Name:                                                           
* 	CE2_ATP_TST_DH_CheckDomainParams_Acceptance
* 
* Inputs:
* 	out - pointer to output log file;
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a Acceptance test for the Diffie-Hellman key agreement 
*  schemes according to ANSI9.42 using full keys test method: P, Q, G, Seed.
*
* Algorithm:		
* 1. Check P, Q, G and Seed using CE2_DH_CheckDomainParams method.
******************************************************************************/
CE2Error_t CE2_ATP_TST_DH_CheckDomainParams_Acceptance(FILE* out);

/*****************************************************************************
* Function Name:                                                           
* 	CE2_ATP_TST_DH_CheckDomainParams_Acceptance
* 
* Inputs:
* 	out - pointer to output log file;
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a Acceptance test for the Diffie-Hellman key agreement 
*  schemes according to ANSI9.42 using full keys test method: yU, yV.
*
* Algorithm:		
* 1. Check public keys using CE2_DH_CheckPubKey method with test values.
******************************************************************************/
CE2Error_t CE2_ATP_TST_DH_CheckPubKey_Acceptance(FILE* out);

#ifdef __cplusplus
}
#endif

#endif /* CE2_TST_DH_KG_H */
